package net.sf.twip.verify;

import net.sf.twip.TwipExtension;

import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/**
 * Initializes and checks that all calls to
 * {@link Verify#verifyThat(Object, org.hamcrest.Matcher) verifyThat} passed.
 */
public class VerifyExtension implements TwipExtension {

	private static final class TwipVerifyStatement extends Statement {
		private final Statement statement;

		public TwipVerifyStatement(Statement statement) {
			this.statement = statement;
		}

		@Override
		public void evaluate() throws Throwable {
			final Verification verification = Verify.initVerifications();
			try {
				statement.evaluate();
			} catch (final AssertionError e) {
				handleThrowable(verification, e);
			} catch (final RuntimeException e) {
				handleThrowable(verification, e);
			} finally {
				Verify.cleanupVerifications();
			}
			verification.check();
		}

		private <T extends Throwable> void handleThrowable(final Verification verification, final T e)
				throws T {
			if (verification.isEmpty())
				throw e;
			verification.add(e);
			verification.check();
		}
	}

	public Statement wrap(boolean beforeSetup, FrameworkMethod method, Object testInstance,
			Statement statement) {
		return beforeSetup ? new TwipVerifyStatement(statement) : statement;
	}
}
