package net.sf.twip.verify;

import org.hamcrest.Matcher;

public class Verify {
	private static final ThreadLocal<Verification> CURRENT_VERIFICATION = new ThreadLocal<Verification>();

	static Verification cleanupVerifications() throws VerificationNotInitializedError {
		final Verification currentVerification = CURRENT_VERIFICATION.get();
		if (currentVerification == null)
			throw new VerificationNotInitializedError();
		CURRENT_VERIFICATION.set(null);
		return currentVerification;
	}

	static Verification initVerifications() {
		if (CURRENT_VERIFICATION.get() != null)
			throw new VerificationAlreadyInitializedError();
		final Verification currentVerification = new Verification();
		CURRENT_VERIFICATION.set(currentVerification);
		return currentVerification;
	}

	public static <T> void verifyThat(T actual, Matcher<T> matcher) {
		final Verification currentVerification = CURRENT_VERIFICATION.get();
		if (currentVerification == null)
			throw new VerificationNotInitializedError();
		currentVerification.verifyThat(actual, matcher);
	}

	private Verify() {
		// never construct
	}
}