package net.sf.twip.verify;

import java.util.Collections;
import java.util.List;

import org.hamcrest.Description;

/**
 * This exception is thrown when one or more calls to
 * {@link Verify#verifyThat(Object, org.hamcrest.Matcher) verifyThat} don't
 * match. It collects the descriptions of all verification failures into one
 * exception.
 */
public class VerificationFailedError extends AssertionError {
	private static final long serialVersionUID = 1L;
	private static final String EXPLANATION = "The following verifications failed:";

	private static String format(final List<Description> failures) {
		final StringBuilder message = new StringBuilder(EXPLANATION);
		for (final Description failure : failures) {
			message.append("\n        ").append(failure.toString());
		}

		return message.toString();
	}

	private final List<Description> failures;

	public VerificationFailedError(List<Description> failures) {
		this.failures = failures;
	}

	public List<Description> getFailures() {
		return Collections.unmodifiableList(failures);
	}

	@Override
	public String getMessage() {
		return format(getFailures());
	}
}
