package net.sf.twip.verify;

import java.util.ArrayList;
import java.util.List;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

class Verification {
	private final List<Description> failures = new ArrayList<Description>();

	private <T> void add(T actual, Matcher<T> matcher) {
		final Description description = new StringDescription();
		description.appendValue(actual);
		description.appendText(" ");
		matcher.describeTo(description);
		addLocationDescription(description, new RuntimeException(), 3);

		failures.add(description);
	}

	public void add(Throwable throwable) {
		final Description description = new StringDescription();
		description.appendText("and then there was a ");
		description.appendValue(throwable);
		addLocationDescription(description, throwable, 1);

		failures.add(description);
	}

	private void addLocationDescription(final Description description, final Throwable throwable,
			int stackTraceIndex) {
		description.appendText("\nat ").appendText(throwable.getStackTrace()[stackTraceIndex].toString());
	}

	public void check() {
		if (!failures.isEmpty()) {
			throw new VerificationFailedError(failures);
		}
	}

	public boolean isEmpty() {
		return failures.isEmpty();
	}

	public <T> void verifyThat(T actual, Matcher<T> matcher) {
		if (!matcher.matches(actual)) {
			add(actual, matcher);
		}
	}
}