package net.sf.twip.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * An {@link Iterator} that traverses a {@link List} in reverse order by using a
 * {@link ListIterator}.
 */
public class ReverseIterator<T> implements Iterator<T> {

	private final ListIterator<T> iter;

	public ReverseIterator(List<T> list) {
		this.iter = list.listIterator(list.size());
	}

	public boolean hasNext() {
		return iter.hasPrevious();
	}

	public T next() {
		return iter.previous();
	}

	public void remove() {
		iter.remove();
	}
}
