package net.sf.twip.util;

import java.util.Iterator;
import java.util.List;

/**
 * An {@link Iterable} that traverses a {@link List} in reverse order by using a
 * {@link ReverseIterator}.
 * 
 * @see ReverseIterator
 */
public class ReverseIterable<T> implements Iterable<T> {

	public static <T> Iterable<T> create(List<T> list) {
		return new ReverseIterable<T>(list);
	}

	private final List<T> list;

	public ReverseIterable(List<T> list) {
		this.list = list;
	}

	public Iterator<T> iterator() {
		return new ReverseIterator<T>(list);
	}
}
