package net.sf.twip.parameterhandler;

import net.sf.twip.util.Parameter;

public class ShortParameterHandler extends AbstractNumberParameterHandler {

	private static final Short[] VALUES = new Short[] { (short) 1, (short) 2, (short) 3, (short) 0,
			(short) -1, (short) -2, (short) -3, (short) 127, (short) -127, (short) 1024, (short) -1024,
			Short.MAX_VALUE, Short.MIN_VALUE };

	public ShortParameterHandler(Parameter parameter) {
		super(parameter);
	}

	@Override
	protected Comparable<? extends Number> getComparable(String numberExpression) {
		return Short.valueOf(numberExpression);
	}

	@Override
	protected Object[] getDefaultParameterValues() {
		return VALUES;
	}
}
