package net.sf.twip.parameterhandler;

import net.sf.twip.util.Parameter;

public class LongParameterHandler extends AbstractNumberParameterHandler {

	private static final Long[] VALUES = new Long[] { 1l, 2l, 3l, 0l, -1l, -2l, -3l, 127l, -127l, 1024l,
			-1024l, Long.MAX_VALUE, Long.MIN_VALUE };

	public LongParameterHandler(Parameter parameter) {
		super(parameter);
	}

	@Override
	protected Comparable<? extends Number> getComparable(String numberExpression) {
		return Long.valueOf(numberExpression);
	}

	@Override
	protected Object[] getDefaultParameterValues() {
		return VALUES;
	}
}
