package net.sf.twip.parameterhandler;

import net.sf.twip.util.Parameter;

public class IntegerParameterHandler extends AbstractNumberParameterHandler {

	private static final Integer[] VALUES = new Integer[] { 1, 2, 3, 0, -1, -2, -3, 127, -127, 1024, -1024,
			Integer.MAX_VALUE, Integer.MIN_VALUE };

	public IntegerParameterHandler(Parameter parameter) {
		super(parameter);
	}

	@Override
	protected Comparable<? extends Number> getComparable(String numberExpression) {
		return Integer.valueOf(numberExpression);
	}

	@Override
	protected Object[] getDefaultParameterValues() {
		return VALUES;
	}
}
