package net.sf.twip.parameterhandler;

import net.sf.twip.util.Parameter;

public class FloatParameterHandler extends AbstractFloatingPointNumberParameterHandler {

	private static final Float[] VALUES = new Float[] { 1f, 1.5f, 2f, 2.5f, 3f, 0f, 1.0f / 9, -1f, -1.5f,
			-2f, -2.5f, -3f, 127f, -127f, 1024f, -1024f, Float.NaN, Float.NEGATIVE_INFINITY,
			Float.POSITIVE_INFINITY, Float.MAX_VALUE, Float.MIN_VALUE };

	public FloatParameterHandler(Parameter parameter) {
		super(parameter);
	}

	@Override
	protected Comparable<? extends Number> getComparable(String numberExpression) {
		return Float.valueOf(numberExpression);
	}

	@Override
	protected Object[] getDefaultParameterValues() {
		return VALUES;
	}

	@Override
	protected boolean isNaN(Object value) {
		return ((Float) value).isNaN();
	}

	@Override
	protected boolean isNegativeInfinity(Object value) {
		final Float f = (Float) value;
		return f.isInfinite() && f < 0;
	}

	@Override
	protected boolean isPositiveInfinity(Object value) {
		final Float f = (Float) value;
		return f.isInfinite() && f > 0;
	}

	@Override
	public boolean test(Object value) {
		if (((Float) value).isNaN())
			return false;
		return super.test(value);
	}
}
