package net.sf.twip.parameterhandler;

import net.sf.twip.internal.TwipConfigurationErrorInvalidEnumAssume;
import net.sf.twip.util.Parameter;

/**
 * Enums can be compared by their ordinal.
 */
public class EnumParameterHandler extends AbstractNumberParameterHandler {
	public EnumParameterHandler(Parameter parameter) {
		super(parameter);
	}

	@Override
	protected Comparable<? extends Number> getComparable(String value) {
		final Object[] values = getDefaultParameterValues();
		for (int i = 0; i < values.length; i++) {
			if (value.equals(values[i].toString())) {
				return i;
			}
		}
		throw new TwipConfigurationErrorInvalidEnumAssume("invalid enum value " + value
				+ " in Assume expression");
	}

	@Override
	protected Object[] getDefaultParameterValues() {
		return parameter.getType().getEnumConstants();
	}

	@Override
	public boolean test(Object value) {
		final Object[] values = getDefaultParameterValues();
		for (int i = 0; i < values.length; i++) {
			if (value.equals(values[i])) {
				return super.test(i);
			}
		}
		throw new TwipConfigurationErrorInvalidEnumAssume("invalid enum value " + value
				+ " in Assume expression!!!");
	}
}
