package net.sf.twip.parameterhandler;

import net.sf.twip.util.Parameter;

public class DoubleParameterHandler extends AbstractFloatingPointNumberParameterHandler {

	private static final Double[] VALUES = new Double[] { 1d, 1.5d, 2d, 2.5d, 3d, 0d, 1.0d / 9, -1d, -1.5d,
			-2d, -2.5d, -3d, 127d, -127d, 1024d, -1024d, Double.NaN, Double.NEGATIVE_INFINITY,
			Double.POSITIVE_INFINITY, Double.MAX_VALUE, Double.MIN_VALUE };

	public DoubleParameterHandler(Parameter parameter) {
		super(parameter);
	}

	@Override
	protected Comparable<? extends Number> getComparable(String numberExpression) {
		return Double.valueOf(numberExpression);
	}

	@Override
	protected Object[] getDefaultParameterValues() {
		return VALUES;
	}

	@Override
	protected boolean isNaN(Object value) {
		return ((Double) value).isNaN();
	}

	@Override
	protected boolean isNegativeInfinity(Object value) {
		final Double d = (Double) value;
		return d.isInfinite() && d < 0;
	}

	@Override
	protected boolean isPositiveInfinity(Object value) {
		final Double d = (Double) value;
		return d.isInfinite() && d > 0;
	}

	@Override
	public boolean test(Object value) {
		if (((Double) value).isNaN())
			return false;
		return super.test(value);
	}
}
