package net.sf.twip.parameterhandler;

import net.sf.twip.util.Parameter;

public class ByteParameterHandler extends AbstractNumberParameterHandler {

	private static final Byte[] VALUES = new Byte[] { (byte) 1, (byte) 2, (byte) 3, (byte) 0, (byte) -1,
			(byte) -2, (byte) -3, Byte.MAX_VALUE, Byte.MIN_VALUE };

	public ByteParameterHandler(Parameter parameter) {
		super(parameter);
	}

	@Override
	protected Comparable<? extends Number> getComparable(String numberExpression) {
		return Byte.valueOf(numberExpression);
	}

	@Override
	protected Object[] getDefaultParameterValues() {
		return VALUES;
	}
}
