package net.sf.twip.parameterhandler;

import net.sf.twip.util.Parameter;

public abstract class AbstractFloatingPointNumberParameterHandler extends AbstractNumberParameterHandler {

	public AbstractFloatingPointNumberParameterHandler(Parameter parameter) {
		super(parameter);
	}

	@Override
	protected Tester getTester(final String expression) {
		if ("!= NaN".equals(expression))
			return new Tester() {
				public boolean test(Object value) {
					return !isNaN(value);
				}
			};
		if ("!= INF".equals(expression))
			return new Tester() {
				public boolean test(Object value) {
					return !isPositiveInfinity(value);
				}
			};
		if ("!= -INF".equals(expression))
			return new Tester() {
				public boolean test(Object value) {
					return !isNegativeInfinity(value);
				}
			};
		return super.getTester(expression);
	}

	protected abstract boolean isNaN(Object value);

	protected abstract boolean isNegativeInfinity(Object value);

	protected abstract boolean isPositiveInfinity(Object value);
}
