/**
 * 
 */
package net.sf.twip.mockito;

import org.junit.runners.model.Statement;
import org.mockito.MockitoAnnotations;

final class MockitoInitStatement extends Statement {
	private final Statement statement;
	private final Object testInstance;

	public MockitoInitStatement(Statement statement, Object testInstance) {
		this.statement = statement;
		this.testInstance = testInstance;
	}

	@Override
	public void evaluate() throws Throwable {
		MockitoAnnotations.initMocks(testInstance);
		statement.evaluate();
	}
}