package net.sf.twip.mockito;

import net.sf.twip.TwipExtension;
import net.sf.twip.util.ServiceLoaderWrapper;

import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mockito.Mock;

/**
 * Allows you to use the {@link org.mockito.Mockito mockito} {@link Mock @Mock}
 * annotation.
 */
public class MockitoExtension implements TwipExtension {

	private boolean checked = false;
	private boolean found = false;

	private synchronized void check() {
		if (!checked) {
			checked = true;
			found = ServiceLoaderWrapper.classExists("org.mockito.Mockito");
		}
	}

	public Statement wrap(boolean beforeSetup, FrameworkMethod method, Object testInstance,
			Statement statement) {
		check();
		if (!found)
			return statement;
		return beforeSetup ? new MockitoValidateStatement(statement) : new MockitoInitStatement(statement,
				testInstance);
	}
}
