package net.sf.twip.jmock;

import net.sf.twip.TwiP;
import net.sf.twip.TwipExtensions;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.runner.RunWith;

/**
 * Convenience upper class for tests that use {@link TwiP} <b>and</b>
 * {@link JMock}: It is annotated with TwiP and TwiPs JMock-Extension, declares
 * a {@link Mockery} instance, and a simple check(Expectations) method.
 * <p>
 * For an example, see
 * {@link net.sf.twip.jmock.TwiPJMockTestWithInheritedMockery}.
 */
@RunWith(TwiP.class)
@TwipExtensions( { JMockExtension.class })
abstract public class TwiPjMockTest {

	/** A readily defined {@link Mockery} for subclasses to use */
	protected final Mockery mockery = new JUnit4Mockery();

	/** Add these {@link Expectations} to the {@link Mockery}. */
	protected void check(Expectations expectations) {
		mockery.checking(expectations);
	}
}
