/**
 * 
 */
package net.sf.twip.jmock;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.junit.runners.model.Statement;

/**
 * A {@link Statement} that tests if the {@link Mockery} is satisfied, i.e. all
 * {@link Expectations} where met, after the tests are run.
 */
class JMockStatement extends Statement {
	private final Statement wrappedStatement;
	private final Mockery mockery;

	JMockStatement(Statement wrappedStatement, Mockery mockery) {
		this.wrappedStatement = wrappedStatement;
		this.mockery = mockery;
	}

	@Override
	public void evaluate() throws Throwable {
		try {
			wrappedStatement.evaluate();
		} finally {
			mockery.assertIsSatisfied();
		}
	}
}