package net.sf.twip.jmock;

import net.sf.twip.TwipExtension;
import net.sf.twip.util.ServiceLoaderWrapper;

import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/**
 * A {@link TwipExtension} that creates a
 * {@link org.jmock.integration.junit4.JMock}-{@link org.jmock.Mockery} and
 * mocks all member variables of the test class that are annotated by
 * {@link Mock}. If there is already a Mockery defined, use that. If it is just
 * declared, but not initialized, do that.
 * <p>
 * This extension delegates to the {@link JMockExtensionDelegate} only if JMock
 * is on the classpath.
 */
public class JMockExtension implements TwipExtension {

	private boolean checked = false;

	private JMockExtensionDelegate delegate = null;

	private synchronized void check() {
		if (!checked) {
			checked = true;
			if (ServiceLoaderWrapper.classExists("org.jmock.Mockery")) {
				delegate = new JMockExtensionDelegate();
			}
		}
	}

	public Statement wrap(boolean beforeSetup, FrameworkMethod method, final Object testInstance,
			final Statement wrappedStatement) {
		check();
		if (delegate == null)
			return wrappedStatement;
		return delegate.wrap(beforeSetup, method, testInstance, wrappedStatement);
	}
}
