package net.sf.twip.internal;

import java.lang.reflect.Method;

import org.junit.runners.model.FrameworkMethod;

/**
 * A dummy {@link FrameworkMethod} that just throws an exception on
 * {@link FrameworkMethod#invokeExplosively(Object, Object...)}
 */
public class FailedFrameworkMethod extends FrameworkMethod {

	private final Throwable throwable;

	public FailedFrameworkMethod(Method method, Throwable throwable) {
		super(method);
		this.throwable = throwable;
	}

	@Override
	public Object invokeExplosively(Object target, Object... params) throws Throwable {
		throw throwable;
	}
}
