package net.sf.twip;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies the name of a static field or method in the test class that is
 * resp. returns a Collection or array of values for a {@link TwiP test method
 * parameter}.
 * <p>
 * Note that you can use the {@link AutoTwip} annotation instead.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface Values {

	String value();
}
