package net.sf.twip;

import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/**
 * Allows to {@link #wrap(boolean, FrameworkMethod, Object, Statement) wrap} a
 * JUnit- {@link Statement}.
 * 
 * @see TwipExtensions
 */
public interface TwipExtension {

	/**
	 * Decorate a JUnit {@link Statement} into a new one and thereby extend the
	 * functionality of JUnit. This method is called twice, first with
	 * <code>beforeSetup == true</code>, so the Statement you wrap is executed
	 * <i>before</i> the {@link org.junit.Before}s are executed; this is what
	 * you'll want to initialize things. The second call is with
	 * <code>beforeSetup == false</code>, so the Statement you wrap is executed
	 * <i>after</i> the {@link org.junit.After}s are executed; this is what
	 * you'll want to verify things.
	 * 
	 * @param beforeSetup
	 *            Will the wrapped statement be executed before the setup is
	 *            done or thereafter?
	 * @param method
	 *            The test method that is to be called.
	 * @param testInstance
	 *            The test instance on which the method is called.
	 * @param statement
	 *            The {@link Statement} that you can wrap.
	 * 
	 * @return a new {@link Statement} wrapping the one passed in; or directly
	 *         that, if you choose not to wrap anything.
	 */
	public Statement wrap(boolean beforeSetup, FrameworkMethod method, Object testInstance,
			Statement statement);

}
