package net.sf.twip;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotate a public static method or field to use it automatically for TwiP
 * parameters of its type, instead of annotating those parameters with
 * {@link Values}.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target( { ElementType.FIELD, ElementType.METHOD })
public @interface AutoTwip {
	// empty
}
