package net.sf.twip;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import net.sf.twip.parameterhandler.ParameterHandler;

/**
 * Limits the set of valid values for a {@link TwiP parameter to a test method}.
 * 
 * @see ParameterHandler for the allowed expressions
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface Assume {

	String value();
}
