/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.dosideas.twip;

import java.util.Date;
import net.sf.twip.Assume;
import net.sf.twip.AutoTwip;
import net.sf.twip.TwiP;
import net.sf.twip.Values;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * Es necesario usar el Runner de TwiP para que pueda integrarse con JUnit.
 */
@RunWith(TwiP.class)
public class TwipDemoTest {

    /** Este array de String será usado por uno de los métodos para probar
     * con estos objetos en vez de usar objetos predeterminados por TwiP.
     */
    public static final String[] MI_STRINGS = {null, "A", "B", "C"};

    /**
     * Este método será usado por TwiP para construir objetos Persona.
     * TwiP invoca este método con parámetros "aleatorios" y va creando
     * distintos objetos Persona.
     * Los parámetros en relaidad no son "aleatorios", sino que forman parte
     * de un conjunto de datos predeterminados por TwiP para los tipos de datos
     * básicos (int, long, String, etc.). La cantidad de objetos Persona que
     * se construirán es la combinación posible entre estos datos predeterminados.
     */
    @AutoTwip
    public static Persona crearPersona(long id, String nombre, String apellido) {
        return new Persona(id, nombre, apellido);
    }


    /**
     * Una forma rápida de construir varios Date es usar los valores predeterminados
     * que TwiP usa para los int/long. Las fechas son variadas, aunque no recientes.
     * Si se desean fechas en particular, se podría crear un array de Date (como
     * la variable MI_STRING).
     */
    @AutoTwip
    public static Date crearDates(long fecha) {
        return new Date(fecha);
    }

    /**
     * TwiP invocará a esta prueba varias veces con distintos valores para el
     * long "b". Estos valores suelen ser valores "frontera" de este tipo de
     * datos.
     */
    @Test
    public void pruebaConUnLong(long b) {
        System.out.println("Número:" + b);
    }

    /**
     * TwiP invocará a esta prueba varias veces con distintos valores para el
     * String "string". Estos valores suelen ser valores "frontera" de este tipo de
     * datos. De forma predeterminada no se incluye un "null".
     */
    @Test
    public void pruebaConString(String string) {
        System.out.println("String: |" + string + "|");
    }

    /**
     * TwiP invocará a esta prueba varias veces con distintos valores para el
     * String "string". Estos valores suelen ser valores "frontera" de este tipo de
     * datos.
     * La anotación @Asumme hace que se incluya al valor "null" como posible.
     */
    @Test
    public void pruebaConStringYNull(@Assume("=null") String string) {
        System.out.println("String y null: |" + string + "|");
    }

    /**
     * TwiP invocará a esta prueba varias veces con distintos valores para el
     * String "string". Estos valores serán sacados del array MI_STRINGS.
     */
    @Test
    public void pruebaConStringDeterminados(@Values("MI_STRINGS") String string) {
        System.out.println("String determinado: |" + string + "|");
    }

    /**
     * TwiP invocará a esta prueba varias veces con distintos valores para el
     * objeto Persona. Los objetos Persona serán creados gracias al método
     * crearPersona() anotado con @AutoTwip.
     */
    @Test
    public void pruebaConObjetoPropio(Persona persona) {
        System.out.println(persona);
    }


    /**
     * TwiP invocará a esta prueba varias veces con distintos valores para el
     * objeto Date. Los objetos Persona serán creados gracias al método
     * crearDates() anotado con @AutoTwip.
     */
    @Test
    public void pruebaConDate(Date fecha) {
        System.out.println("Fecha: " + fecha);
    }

}
