/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.verify;

import net.sf.twip.TwipExtension;
import net.sf.twip.verify.Verification;
import net.sf.twip.verify.Verify;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class VerifyExtension
implements TwipExtension {
    public Statement wrap(boolean beforeSetup, FrameworkMethod method, Object testInstance, Statement statement) {
        return beforeSetup ? new TwipVerifyStatement(statement) : statement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TwipVerifyStatement
    extends Statement {
        private final Statement statement;

        public TwipVerifyStatement(Statement statement) {
            this.statement = statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            Verification verification = Verify.initVerifications();
            try {
                this.statement.evaluate();
            }
            catch (AssertionError e) {
                this.handleThrowable(verification, e);
            }
            catch (RuntimeException e) {
                this.handleThrowable(verification, e);
            }
            finally {
                Verify.cleanupVerifications();
            }
            verification.check();
        }

        private <T extends Throwable> void handleThrowable(Verification verification, T e) throws T {
            if (verification.isEmpty()) {
                throw e;
            }
            verification.add(e);
            verification.check();
        }
    }
}

