/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.verify;

import net.sf.twip.verify.Verification;
import net.sf.twip.verify.VerificationAlreadyInitializedError;
import net.sf.twip.verify.VerificationNotInitializedError;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verify {
    private static final ThreadLocal<Verification> CURRENT_VERIFICATION = new ThreadLocal();

    static Verification cleanupVerifications() throws VerificationNotInitializedError {
        Verification currentVerification = CURRENT_VERIFICATION.get();
        if (currentVerification == null) {
            throw new VerificationNotInitializedError();
        }
        CURRENT_VERIFICATION.set(null);
        return currentVerification;
    }

    static Verification initVerifications() {
        if (CURRENT_VERIFICATION.get() != null) {
            throw new VerificationAlreadyInitializedError();
        }
        Verification currentVerification = new Verification();
        CURRENT_VERIFICATION.set(currentVerification);
        return currentVerification;
    }

    public static <T> void verifyThat(T actual, Matcher<T> matcher) {
        Verification currentVerification = CURRENT_VERIFICATION.get();
        if (currentVerification == null) {
            throw new VerificationNotInitializedError();
        }
        currentVerification.verifyThat(actual, matcher);
    }

    private Verify() {
    }
}

