/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.verify;

import java.util.ArrayList;
import java.util.List;
import net.sf.twip.verify.VerificationFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Verification {
    private final List<Description> failures = new ArrayList<Description>();

    Verification() {
    }

    private <T> void add(T actual, Matcher<T> matcher) {
        StringDescription description = new StringDescription();
        description.appendValue(actual);
        description.appendText(" ");
        matcher.describeTo((Description)description);
        this.addLocationDescription((Description)description, new RuntimeException(), 3);
        this.failures.add((Description)description);
    }

    public void add(Throwable throwable) {
        StringDescription description = new StringDescription();
        description.appendText("and then there was a ");
        description.appendValue((Object)throwable);
        this.addLocationDescription((Description)description, throwable, 1);
        this.failures.add((Description)description);
    }

    private void addLocationDescription(Description description, Throwable throwable, int stackTraceIndex) {
        description.appendText("\nat ").appendText(throwable.getStackTrace()[stackTraceIndex].toString());
    }

    public void check() {
        if (!this.failures.isEmpty()) {
            throw new VerificationFailedError(this.failures);
        }
    }

    public boolean isEmpty() {
        return this.failures.isEmpty();
    }

    public <T> void verifyThat(T actual, Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            this.add(actual, matcher);
        }
    }
}

