/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import net.sf.twip.util.ServiceLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoaderWrapper<T>
implements Iterable<T> {
    private final Class<T> type;

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> Iterable<T> load(Class<T> type) {
        return new ServiceLoaderWrapper<T>(type);
    }

    ServiceLoaderWrapper(Class<T> type) {
        this.type = type;
    }

    private Iterator<T> getServiceIterator() {
        Method loadMethod = this.getServiceLoadMethod("sun.misc.Service", "providers");
        if (loadMethod == null) {
            return null;
        }
        Iterator iterator = (Iterator)this.invoke(loadMethod);
        return iterator;
    }

    Class<?> getServiceLoader(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Iterator<T> getServiceLoaderIterator() {
        Method loadMethod = this.getServiceLoadMethod("java.util.ServiceLoader", "load");
        if (loadMethod == null) {
            return null;
        }
        Iterable loader = (Iterable)this.invoke(loadMethod);
        return loader.iterator();
    }

    private Method getServiceLoadMethod(String className, String methodName) {
        Class<?> loaderClass = this.getServiceLoader(className);
        if (loaderClass == null) {
            return null;
        }
        try {
            return loaderClass.getMethod(methodName, Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceLoadingException("the " + className + " class has no '" + methodName + "' method.", e);
        }
    }

    private Object invoke(Method load) {
        try {
            return load.invoke(null, this.type);
        }
        catch (IllegalAccessException e) {
            throw new ServiceLoadingException("ServiceLoader.load throws", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceLoadingException("ServiceLoader.load throws", e.getCause());
        }
        catch (RuntimeException e) {
            throw new ServiceLoadingException("ServiceLoader.load throws", e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> iterator = this.getServiceLoaderIterator();
        if (iterator == null) {
            iterator = this.getServiceIterator();
        }
        if (iterator == null) {
            throw new ServiceLoadingException("can't find ServiceLoader class");
        }
        return iterator;
    }
}

