/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter {
    private final Method method;
    private final int index;

    public static List<Parameter> of(Method method) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            list.add(new Parameter(method, i));
        }
        return Collections.unmodifiableList(list);
    }

    public Parameter(Method method, int index) {
        this.method = method;
        this.index = index;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationType.isInstance(annotation)) continue;
            return (T)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.method.getParameterAnnotations()[this.index];
    }

    public int getIndex() {
        return this.index;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getType() {
        return this.method.getParameterTypes()[this.index];
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public String toString() {
        return Parameter.class.getSimpleName() + "#" + this.getIndex() + " of " + this.getMethod().toGenericString();
    }
}

