/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.parameterhandler;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.twip.Assume;
import net.sf.twip.NotNull;
import net.sf.twip.Values;
import net.sf.twip.internal.TwipConfigurationErrorCallingMethod;
import net.sf.twip.internal.TwipConfigurationErrorGettingField;
import net.sf.twip.internal.TwipConfigurationErrorNoSuchMethod;
import net.sf.twip.internal.TwipConfigurationErrorNonPrimitive;
import net.sf.twip.internal.TwipConfigurationErrorNonStatic;
import net.sf.twip.internal.TwipConfigurationErrorNotArrayOrCollection;
import net.sf.twip.internal.TwipConfigurationErrorNullPointer;
import net.sf.twip.util.Parameter;

public abstract class ParameterHandler {
    protected final Parameter parameter;

    public ParameterHandler(Parameter parameter) {
        this.parameter = parameter;
    }

    private Object[] getAnnotatedValues(Parameter parameter) {
        String name = parameter.getAnnotation(Values.class).value();
        try {
            Field field = parameter.getMethod().getDeclaringClass().getField(name);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new TwipConfigurationErrorNonStatic("the field '" + name + "' named in the @Values annotation of " + parameter + " must be static.");
            }
            if (field.getType().isArray()) {
                if (field.getType().getComponentType().isPrimitive()) {
                    throw new TwipConfigurationErrorNonPrimitive("the values of the field '" + name + "' named in the @Values annotation of " + parameter + " must not be primitives.");
                }
                Object[] result = (Object[])field.get(null);
                if (result == null) {
                    throw new TwipConfigurationErrorNullPointer("the field '" + name + "' named in the @Values annotation of " + parameter + " is null");
                }
                return result;
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection result = (Collection)field.get(null);
                if (result == null) {
                    throw new TwipConfigurationErrorNullPointer("the field '" + name + "' named in the @Values annotation of " + parameter + " is null");
                }
                return result.toArray();
            }
            throw new TwipConfigurationErrorNotArrayOrCollection("the field '" + name + "' named in the @Values annotation of " + parameter + " must be an array or collection.");
        }
        catch (IllegalAccessException e) {
            throw new TwipConfigurationErrorGettingField("can't access field '" + name + "' named in the @Values annotation of " + parameter, e);
        }
        catch (NoSuchFieldException ex) {
            try {
                Method method = parameter.getMethod().getDeclaringClass().getMethod(name, new Class[0]);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new TwipConfigurationErrorNonStatic("the method '" + name + "' named in the @Values annotation of " + parameter + " must be static.");
                }
                if (method.getReturnType().isArray()) {
                    if (method.getReturnType().getComponentType().isPrimitive()) {
                        throw new TwipConfigurationErrorNonPrimitive("the values returned by the method '" + name + "' named in the @Values annotation of " + parameter + " must not be primitives.");
                    }
                    Object[] result = (Object[])method.invoke(null, new Object[0]);
                    if (result == null) {
                        throw new TwipConfigurationErrorNullPointer("the method '" + name + "' named in the @Values annotation of " + parameter + " returns null");
                    }
                    return result;
                }
                if (Collection.class.isAssignableFrom(method.getReturnType())) {
                    Collection collection = (Collection)method.invoke(null, new Object[0]);
                    if (collection == null) {
                        throw new TwipConfigurationErrorNullPointer("the method '" + name + "' named in the @Values annotation of " + parameter + " returns null.");
                    }
                    return collection.toArray();
                }
                throw new TwipConfigurationErrorNotArrayOrCollection("the method '" + name + "' named in the @Values annotation of " + parameter + " must return an array or collection.");
            }
            catch (IllegalAccessException e) {
                throw new TwipConfigurationErrorCallingMethod("can't access the method '" + name + "' named in the @Values annotation of " + parameter, e);
            }
            catch (NoSuchMethodException e) {
                throw new TwipConfigurationErrorNoSuchMethod("there is no method or field '" + name + "' named in the @Values annotation of " + parameter, e);
            }
            catch (InvocationTargetException e) {
                throw new TwipConfigurationErrorCallingMethod("can't invoke method '" + name + "' named in the @Values annotation of " + parameter, e);
            }
        }
    }

    protected abstract Object[] getDefaultParameterValues();

    public Object[] getParameterValues() {
        Object[] values;
        Object[] objectArray = values = this.parameter.isAnnotationPresent(Values.class) ? this.getAnnotatedValues(this.parameter) : this.getDefaultParameterValues();
        if (!this.parameter.isAnnotationPresent(Assume.class)) {
            return values;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            if (!this.test(value)) continue;
            result.add(value);
        }
        if (!this.parameter.isAnnotationPresent(NotNull.class) && !this.parameter.getType().isPrimitive()) {
            result.add(null);
        }
        return result.toArray();
    }

    protected boolean test(Object value) {
        return true;
    }
}

