/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.parameterhandler;

import net.sf.twip.parameterhandler.AbstractFloatingPointNumberParameterHandler;
import net.sf.twip.util.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatParameterHandler
extends AbstractFloatingPointNumberParameterHandler {
    private static final Float[] VALUES = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.5f), Float.valueOf(2.0f), Float.valueOf(2.5f), Float.valueOf(3.0f), Float.valueOf(0.0f), Float.valueOf(0.11111111f), Float.valueOf(-1.0f), Float.valueOf(-1.5f), Float.valueOf(-2.0f), Float.valueOf(-2.5f), Float.valueOf(-3.0f), Float.valueOf(127.0f), Float.valueOf(-127.0f), Float.valueOf(1024.0f), Float.valueOf(-1024.0f), Float.valueOf(Float.NaN), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE)};

    public FloatParameterHandler(Parameter parameter) {
        super(parameter);
    }

    @Override
    protected Comparable<? extends Number> getComparable(String numberExpression) {
        return Float.valueOf(numberExpression);
    }

    @Override
    protected Object[] getDefaultParameterValues() {
        return VALUES;
    }

    @Override
    protected boolean isNaN(Object value) {
        return ((Float)value).isNaN();
    }

    @Override
    protected boolean isNegativeInfinity(Object value) {
        Float f = (Float)value;
        return f.isInfinite() && f.floatValue() < 0.0f;
    }

    @Override
    protected boolean isPositiveInfinity(Object value) {
        Float f = (Float)value;
        return f.isInfinite() && f.floatValue() > 0.0f;
    }

    @Override
    public boolean test(Object value) {
        if (((Float)value).isNaN()) {
            return false;
        }
        return super.test(value);
    }
}

