/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.parameterhandler;

import net.sf.twip.parameterhandler.AbstractFloatingPointNumberParameterHandler;
import net.sf.twip.util.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleParameterHandler
extends AbstractFloatingPointNumberParameterHandler {
    private static final Double[] VALUES = new Double[]{1.0, 1.5, 2.0, 2.5, 3.0, 0.0, 0.1111111111111111, -1.0, -1.5, -2.0, -2.5, -3.0, 127.0, -127.0, 1024.0, -1024.0, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.MAX_VALUE, Double.MIN_VALUE};

    public DoubleParameterHandler(Parameter parameter) {
        super(parameter);
    }

    @Override
    protected Comparable<? extends Number> getComparable(String numberExpression) {
        return Double.valueOf(numberExpression);
    }

    @Override
    protected Object[] getDefaultParameterValues() {
        return VALUES;
    }

    @Override
    protected boolean isNaN(Object value) {
        return ((Double)value).isNaN();
    }

    @Override
    protected boolean isNegativeInfinity(Object value) {
        Double d = (Double)value;
        return d.isInfinite() && d < 0.0;
    }

    @Override
    protected boolean isPositiveInfinity(Object value) {
        Double d = (Double)value;
        return d.isInfinite() && d > 0.0;
    }

    @Override
    public boolean test(Object value) {
        if (((Double)value).isNaN()) {
            return false;
        }
        return super.test(value);
    }
}

