/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.parameterhandler;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.twip.AutoTwip;
import net.sf.twip.TwiP;
import net.sf.twip.internal.FrameworkMethodWithArgs;
import net.sf.twip.internal.TwipConfigurationErrorCallingMethod;
import net.sf.twip.internal.TwipConfigurationErrorDuplicateAutoTwip;
import net.sf.twip.internal.TwipConfigurationErrorGettingField;
import net.sf.twip.internal.TwipConfigurationErrorNonStatic;
import net.sf.twip.internal.TwipConfigurationErrorNotArrayOrCollection;
import net.sf.twip.internal.TwipConfigurationErrorNullPointer;
import net.sf.twip.internal.TwipConfigurationErrorUnknownParameterType;
import net.sf.twip.internal.TwipConfigurationErrorVoidAutoTwipMethod;
import net.sf.twip.parameterhandler.ParameterHandler;
import net.sf.twip.util.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoTwipParameterHandler
extends ParameterHandler {
    private final AutoTwipHandler autoTwipHandler;

    public AutoTwipParameterHandler(Parameter parameter) {
        super(parameter);
        this.autoTwipHandler = this.findAutoTwip(parameter);
    }

    private void fillAutoTwipFields(Map<Class<?>, AutoTwipHandler> handlers, Class<?> declaringClass) {
        for (Field field : declaringClass.getDeclaredFields()) {
            AutoTwipHandler handler;
            if (!field.isAnnotationPresent(AutoTwip.class)) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new TwipConfigurationErrorNonStatic("the field " + field + " is annotated as @AutoTwip, but it is not static!");
            }
            Class type = field.getType();
            if (type.isArray()) {
                type = type.getComponentType();
                handler = new AutoTwipFieldArrayHandler(field);
            } else if (Collection.class.isAssignableFrom(type)) {
                ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                type = (Class)parameterizedType.getActualTypeArguments()[0];
                handler = new AutoTwipFieldCollectionHandler(field);
            } else {
                throw new TwipConfigurationErrorNotArrayOrCollection("the field " + field + " is annotated as @AutoTwip, but it's not an array or collection!");
            }
            AutoTwipHandler old = handlers.put(type, handler);
            if (old == null) continue;
            throw new TwipConfigurationErrorDuplicateAutoTwip("the field " + field + " is annotated as @AutoTwip, but it's of the same type as the AutoTwip " + old);
        }
    }

    private void fillAutoTwipMethods(Map<Class<?>, AutoTwipHandler> handlers, Class<?> declaringClass) {
        for (Method method : declaringClass.getDeclaredMethods()) {
            AbstractAutoTwipMethodHandler handler;
            if (!method.isAnnotationPresent(AutoTwip.class)) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new TwipConfigurationErrorNonStatic("the method " + method + " is annotated as @AutoTwip, but it is not static!");
            }
            Class type = method.getReturnType();
            if (Void.TYPE.equals(type)) {
                throw new TwipConfigurationErrorVoidAutoTwipMethod("the method " + method + " is annotated as @AutoTwip, but it returns void!");
            }
            if (type.isArray()) {
                type = type.getComponentType();
                handler = new AutoTwipMethodArrayHandler(method);
            } else if (Collection.class.isAssignableFrom(type)) {
                ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
                type = (Class)parameterizedType.getActualTypeArguments()[0];
                handler = new AutoTwipMethodCollectionHandler(method);
            } else {
                handler = new AutoTwipMethodResultHandler(method);
            }
            AutoTwipHandler old = handlers.put(type, handler);
            if (old == null) continue;
            throw new TwipConfigurationErrorDuplicateAutoTwip("the method " + method + " is annotated as @AutoTwip, but it returns the same type as the AutoTwip " + old);
        }
    }

    private AutoTwipHandler findAutoTwip(Parameter parameter) {
        Map<Class<?>, AutoTwipHandler> handlers = this.findAutoTwipHandlers(parameter.getMethod().getDeclaringClass());
        return handlers.get(parameter.getType());
    }

    private Map<Class<?>, AutoTwipHandler> findAutoTwipHandlers(Class<?> declaringClass) {
        HashMap handlers = new HashMap();
        this.fillAutoTwipMethods(handlers, declaringClass);
        this.fillAutoTwipFields(handlers, declaringClass);
        return handlers;
    }

    @Override
    protected Object[] getDefaultParameterValues() {
        if (this.autoTwipHandler == null) {
            throw new TwipConfigurationErrorUnknownParameterType("TwiP can't produce parameters of type [" + this.parameter.getType().getName() + "]. Please add a @Value annotation to parameter #" + this.parameter.getIndex() + " of method " + this.parameter.getMethod() + " or declare a @AutoTwip field or method.");
        }
        Object[] result = this.autoTwipHandler.run();
        if (result == null) {
            throw new TwipConfigurationErrorNullPointer("The AutoTwip " + this.autoTwipHandler + " is/returns null");
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AutoTwipMethodResultHandler
    extends AbstractAutoTwipMethodHandler {
        public AutoTwipMethodResultHandler(Method method) {
            super(method);
        }

        @Override
        public void invoke(FrameworkMethodWithArgs method, List<Object> result) throws Throwable {
            Object object = method.invokeExplosively(null, new Object[0]);
            result.add(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AutoTwipMethodCollectionHandler
    extends AbstractAutoTwipMethodHandler {
        public AutoTwipMethodCollectionHandler(Method method) {
            super(method);
        }

        @Override
        public void invoke(FrameworkMethodWithArgs method, List<Object> result) throws Throwable {
            for (Object object : (Collection)method.invokeExplosively(null, new Object[0])) {
                result.add(object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AutoTwipMethodArrayHandler
    extends AbstractAutoTwipMethodHandler {
        public AutoTwipMethodArrayHandler(Method method) {
            super(method);
        }

        @Override
        public void invoke(FrameworkMethodWithArgs method, List<Object> result) throws Throwable {
            for (Object object : (Object[])method.invokeExplosively(null, new Object[0])) {
                result.add(object);
            }
        }
    }

    private static interface AutoTwipHandler {
        public Object[] run();
    }

    private static class AutoTwipFieldCollectionHandler
    implements AutoTwipHandler {
        private final Field field;

        public AutoTwipFieldCollectionHandler(Field field) {
            this.field = field;
        }

        public Object[] run() {
            try {
                return ((Collection)this.field.get(null)).toArray();
            }
            catch (Exception e) {
                throw new TwipConfigurationErrorGettingField("while calling AutoTwip field " + this.field, e);
            }
        }
    }

    private static class AutoTwipFieldArrayHandler
    implements AutoTwipHandler {
        private final Field field;

        public AutoTwipFieldArrayHandler(Field field) {
            this.field = field;
        }

        public Object[] run() {
            try {
                return (Object[])this.field.get(null);
            }
            catch (Exception e) {
                throw new TwipConfigurationErrorGettingField("while calling AutoTwip field " + this.field, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractAutoTwipMethodHandler
    implements AutoTwipHandler {
        private final Method method;

        public AbstractAutoTwipMethodHandler(Method method) {
            this.method = method;
        }

        public abstract void invoke(FrameworkMethodWithArgs var1, List<Object> var2) throws Throwable;

        private TwipConfigurationErrorCallingMethod newMethodCallingError(FrameworkMethodWithArgs parameterizedMethod, Throwable e) {
            return new TwipConfigurationErrorCallingMethod("can't initialize AutoTwip values from " + (Object)((Object)parameterizedMethod), e);
        }

        @Override
        public Object[] run() {
            ArrayList<Object> result = new ArrayList<Object>();
            for (FrameworkMethodWithArgs parameterizedMethod : TwiP.computeParameterizedTestMethods(this.method)) {
                try {
                    this.invoke(parameterizedMethod, result);
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (VirtualMachineError e) {
                    throw e;
                }
                catch (LinkageError e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw this.newMethodCallingError(parameterizedMethod, e);
                }
            }
            return result.toArray();
        }
    }
}

