/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.parameterhandler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.twip.Assume;
import net.sf.twip.internal.TwipConfigurationErrorIllegalAssumeExpression;
import net.sf.twip.parameterhandler.ParameterHandler;
import net.sf.twip.util.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberParameterHandler
extends ParameterHandler {
    private static final Pattern EXPRESSION = Pattern.compile("(<|>|!)(=?)\\s*(-?\\w+)");
    private final Tester tester = this.getTester();

    public AbstractNumberParameterHandler(Parameter parameter) {
        super(parameter);
    }

    protected abstract Comparable<? extends Number> getComparable(String var1);

    private Tester getTester() {
        Assume assumption = this.parameter.getAnnotation(Assume.class);
        if (assumption == null) {
            return new TrueTester();
        }
        String expression = assumption.value();
        return this.getTester(expression);
    }

    protected Tester getTester(String expression) {
        Matcher matcher = EXPRESSION.matcher(expression);
        if (!matcher.matches()) {
            throw new TwipConfigurationErrorIllegalAssumeExpression("illegal assume expression [" + expression + "] for [" + this.parameter.getType().getSimpleName() + "]");
        }
        Comparable<? extends Number> comparable = this.getComparable(matcher.group(3));
        if (">".equals(matcher.group(1))) {
            if ("=".equals(matcher.group(2))) {
                return new GreaterOrEqualsTester(comparable);
            }
            return new GreaterThanTester(comparable);
        }
        if ("<".equals(matcher.group(1))) {
            if ("=".equals(matcher.group(2))) {
                return new LessOrEqualsTester(comparable);
            }
            return new LessThanTester(comparable);
        }
        if ("=".equals(matcher.group(2))) {
            return new EqualsTester(comparable);
        }
        throw new TwipConfigurationErrorIllegalAssumeExpression("illegal assume expression [" + expression + "] for [" + this.parameter.getType().getSimpleName() + "]");
    }

    @Override
    public boolean test(Object value) {
        return this.tester.test(value);
    }

    private static final class TrueTester
    implements Tester {
        private TrueTester() {
        }

        public boolean test(Object value) {
            return true;
        }
    }

    protected static interface Tester {
        public boolean test(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LessThanTester
    implements Tester {
        private final Comparable<Object> comparable;

        private LessThanTester(Comparable<Object> comparable) {
            this.comparable = comparable;
        }

        @Override
        public boolean test(Object value) {
            return value == null || 0 < this.comparable.compareTo(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LessOrEqualsTester
    implements Tester {
        private final Comparable<Object> comparable;

        private LessOrEqualsTester(Comparable<Object> comparable) {
            this.comparable = comparable;
        }

        @Override
        public boolean test(Object value) {
            return value == null || 0 <= this.comparable.compareTo(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GreaterThanTester
    implements Tester {
        private final Comparable<Object> comparable;

        private GreaterThanTester(Comparable<Object> comparable) {
            this.comparable = comparable;
        }

        @Override
        public boolean test(Object value) {
            return value == null || 0 > this.comparable.compareTo(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GreaterOrEqualsTester
    implements Tester {
        private final Comparable<Object> comparable;

        private GreaterOrEqualsTester(Comparable<Object> comparable) {
            this.comparable = comparable;
        }

        @Override
        public boolean test(Object value) {
            return value == null || 0 >= this.comparable.compareTo(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqualsTester
    implements Tester {
        private final Comparable<Object> comparable;

        private EqualsTester(Comparable<Object> comparable) {
            this.comparable = comparable;
        }

        @Override
        public boolean test(Object value) {
            return value == null || 0 != this.comparable.compareTo(value);
        }
    }
}

