/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.mockito;

import net.sf.twip.TwipExtension;
import net.sf.twip.mockito.MockitoInitStatement;
import net.sf.twip.mockito.MockitoValidateStatement;
import net.sf.twip.util.ServiceLoaderWrapper;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class MockitoExtension
implements TwipExtension {
    private boolean checked = false;
    private boolean found = false;

    private synchronized void check() {
        if (!this.checked) {
            this.checked = true;
            this.found = ServiceLoaderWrapper.classExists("org.mockito.Mockito");
        }
    }

    public Statement wrap(boolean beforeSetup, FrameworkMethod method, Object testInstance, Statement statement) {
        this.check();
        if (!this.found) {
            return statement;
        }
        return beforeSetup ? new MockitoValidateStatement(statement) : new MockitoInitStatement(statement, testInstance);
    }
}

