/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.jmock;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.sf.twip.TwipExtension;
import net.sf.twip.jmock.JMockStatement;
import net.sf.twip.jmock.Mock;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMockExtensionDelegate
implements TwipExtension {
    private static final ThreadLocal<Mockery> MOCKERY = new ThreadLocal();

    private List<Field> findMocks(Object testInstance) {
        ArrayList<Field> mocks = new ArrayList<Field>();
        for (Field field : testInstance.getClass().getDeclaredFields()) {
            if (field.getAnnotation(Mock.class) == null) continue;
            field.setAccessible(true);
            mocks.add(field);
        }
        return mocks;
    }

    private Mockery findOrCreateMockery(Object testIntance) {
        for (Class<?> c = testIntance.getClass(); c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (!Mockery.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                try {
                    Mockery mockery = (Mockery)f.get(testIntance);
                    if (mockery == null) {
                        mockery = new JUnit4Mockery();
                        f.set(testIntance, mockery);
                    }
                    return mockery;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    public Statement wrap(boolean beforeSetup, FrameworkMethod method, Object testInstance, Statement wrappedStatement) {
        if (!beforeSetup) {
            return wrappedStatement;
        }
        Mockery mockery = this.findOrCreateMockery(testInstance);
        if (mockery == null) {
            return wrappedStatement;
        }
        MOCKERY.set(mockery);
        for (Field field : this.findMocks(testInstance)) {
            String name = field.getName();
            Class<?> type = field.getType();
            try {
                field.set(testInstance, mockery.mock(type, name));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return new JMockStatement(wrappedStatement, mockery);
    }
}

