/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;

public class FrameworkMethodWithArgs
extends FrameworkMethod {
    private final Object[] parameters;
    private final String description;

    public FrameworkMethodWithArgs(FrameworkMethodWithArgs old, Object parameter) {
        super(old.getMethod());
        int l = old.getName().length();
        this.description = old.getDescription().substring(0, l) + "." + this.toString(parameter) + old.getDescription().substring(l);
        this.parameters = this.insertParameter(old.parameters, parameter);
    }

    public FrameworkMethodWithArgs(Method method) {
        super(method);
        this.description = method.getName();
        this.parameters = new Object[0];
    }

    public String getDescription() {
        return this.description;
    }

    private Object[] insertParameter(Object[] oldParameters, Object newParameter) {
        Object[] parameters = new Object[oldParameters.length + 1];
        System.arraycopy(oldParameters, 0, parameters, 1, oldParameters.length);
        parameters[0] = newParameter;
        return parameters;
    }

    public Object invokeExplosively(Object target, Object ... parameters) throws Throwable {
        Assert.assertEquals((String)"don't call this with parameters; I know them already!", (long)parameters.length, (long)0L);
        Assert.assertEquals((String)"you didn't specify all parameters for the method", (long)this.getMethod().getParameterTypes().length, (long)this.parameters.length);
        return super.invokeExplosively(target, this.parameters);
    }

    public String toString() {
        return this.description + Arrays.toString(this.parameters);
    }

    private String toString(Object parameter) {
        StringBuilder out = new StringBuilder();
        block7: for (char c : String.valueOf(parameter).toCharArray()) {
            switch (c) {
                case '\n': {
                    out.append("\\n");
                    continue block7;
                }
                case '\r': {
                    out.append("\\r");
                    continue block7;
                }
                case '\t': {
                    out.append("\\t");
                    continue block7;
                }
                case '(': {
                    out.append("[");
                    continue block7;
                }
                case ')': {
                    out.append("]");
                    continue block7;
                }
                default: {
                    if (c > '\u0100') {
                        out.append("\\u");
                        out.append(String.format("%04X", c));
                        continue block7;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }
}

