/*
 * Decompiled with CFR 0.152.
 */
package net.sf.twip;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.twip.TwipExtension;
import net.sf.twip.TwipExtensions;
import net.sf.twip.internal.FailedFrameworkMethod;
import net.sf.twip.internal.FrameworkMethodWithArgs;
import net.sf.twip.internal.TwipConfigurationError;
import net.sf.twip.internal.TwipConfigurationErrorCantAccessExtension;
import net.sf.twip.internal.TwipConfigurationErrorCantInstantiateExtension;
import net.sf.twip.parameterhandler.AutoTwipParameterHandler;
import net.sf.twip.parameterhandler.BooleanParameterHandler;
import net.sf.twip.parameterhandler.ByteParameterHandler;
import net.sf.twip.parameterhandler.CharacterParameterHandler;
import net.sf.twip.parameterhandler.DoubleParameterHandler;
import net.sf.twip.parameterhandler.EnumParameterHandler;
import net.sf.twip.parameterhandler.FloatParameterHandler;
import net.sf.twip.parameterhandler.IntegerParameterHandler;
import net.sf.twip.parameterhandler.LongParameterHandler;
import net.sf.twip.parameterhandler.ParameterHandler;
import net.sf.twip.parameterhandler.ShortParameterHandler;
import net.sf.twip.parameterhandler.StringParameterHandler;
import net.sf.twip.util.Parameter;
import net.sf.twip.util.ReverseIterable;
import net.sf.twip.util.ServiceLoaderWrapper;
import net.sf.twip.util.ServiceLoadingException;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwiP
extends BlockJUnit4ClassRunner {
    private List<FrameworkMethod> testMethods;
    private final List<TwipExtension> extensions = new ArrayList<TwipExtension>();

    public static List<FrameworkMethodWithArgs> computeParameterizedTestMethods(Method method) {
        ArrayList<FrameworkMethodWithArgs> result = new ArrayList<FrameworkMethodWithArgs>();
        result.add(new FrameworkMethodWithArgs(method));
        for (Parameter parameter : ReverseIterable.create(Parameter.of(method))) {
            ArrayList<FrameworkMethodWithArgs> next = new ArrayList<FrameworkMethodWithArgs>();
            ParameterHandler parameterHandler = TwiP.getParameterHandler(parameter);
            for (Object value : parameterHandler.getParameterValues()) {
                for (FrameworkMethodWithArgs old : result) {
                    next.add(new FrameworkMethodWithArgs(old, value));
                }
            }
            result = next;
        }
        return result;
    }

    private static ParameterHandler getParameterHandler(Parameter parameter) {
        Class<?> type = parameter.getType();
        if (type.isEnum()) {
            return new EnumParameterHandler(parameter);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.equals(type)) {
            return new BooleanParameterHandler(parameter);
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.equals(type)) {
            return new ByteParameterHandler(parameter);
        }
        if (Character.class.isAssignableFrom(type) || Character.TYPE.equals(type)) {
            return new CharacterParameterHandler(parameter);
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.equals(type)) {
            return new DoubleParameterHandler(parameter);
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.equals(type)) {
            return new FloatParameterHandler(parameter);
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.equals(type)) {
            return new IntegerParameterHandler(parameter);
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.equals(type)) {
            return new LongParameterHandler(parameter);
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.equals(type)) {
            return new ShortParameterHandler(parameter);
        }
        if (String.class.isAssignableFrom(type)) {
            return new StringParameterHandler(parameter);
        }
        return new AutoTwipParameterHandler(parameter);
    }

    public TwiP(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.initExtensions(testClass);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.testMethods == null) {
            this.testMethods = new ArrayList<FrameworkMethod>();
            for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(Test.class)) {
                List<FrameworkMethod> parameterizedTestMethods;
                if (method.getMethod().getParameterTypes().length == 0) {
                    this.testMethods.add(method);
                    continue;
                }
                try {
                    parameterizedTestMethods = TwiP.computeParameterizedTestMethods(method.getMethod());
                }
                catch (TwipConfigurationError e) {
                    parameterizedTestMethods = this.createFailedMethod(method, e);
                }
                this.testMethods.addAll(parameterizedTestMethods);
            }
        }
        return this.testMethods;
    }

    private List<FailedFrameworkMethod> createFailedMethod(FrameworkMethod method, Throwable e) {
        return Collections.singletonList(new FailedFrameworkMethod(method.getMethod(), e));
    }

    private void initExtensions(Class<?> testClass) throws InitializationError {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        Set<Class<? extends TwipExtension>> loaded = this.instantiateServiceLoaderExtensions(errors);
        this.instantiateAnnotatedExtensions(testClass, loaded, errors);
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private void instantiateAnnotatedExtensions(Class<?> testClass, Set<Class<? extends TwipExtension>> loaded, List<Throwable> errors) {
        TwipExtensions annotation = testClass.getAnnotation(TwipExtensions.class);
        if (annotation != null) {
            for (Class<? extends TwipExtension> type : annotation.value()) {
                if (loaded.contains(type)) continue;
                try {
                    this.extensions.add(type.newInstance());
                }
                catch (InstantiationException e) {
                    String message = "can't instantiate " + type;
                    errors.add(new TwipConfigurationErrorCantInstantiateExtension(message, e));
                }
                catch (IllegalAccessException e) {
                    errors.add(new TwipConfigurationErrorCantAccessExtension("can't access " + type, e));
                }
            }
        }
    }

    private Set<Class<? extends TwipExtension>> instantiateServiceLoaderExtensions(List<Throwable> errors) {
        HashSet<Class<? extends TwipExtension>> serviceLoadedTypes = new HashSet<Class<? extends TwipExtension>>();
        Iterator<TwipExtension> loaders = ServiceLoaderWrapper.load(TwipExtension.class).iterator();
        while (loaders.hasNext()) {
            try {
                TwipExtension extension = loaders.next();
                this.extensions.add(extension);
                serviceLoadedTypes.add(extension.getClass());
            }
            catch (ServiceLoadingException e) {
                errors.add(e);
            }
        }
        return serviceLoadedTypes;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object testInstance) {
        Statement statement = super.methodInvoker(method, testInstance);
        for (TwipExtension extension : this.extensions) {
            statement = extension.wrap(true, method, testInstance, statement);
        }
        return statement;
    }

    protected String testName(FrameworkMethod method) {
        return method instanceof FrameworkMethodWithArgs ? ((FrameworkMethodWithArgs)method).getDescription() : super.testName(method);
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(isStatic, errors);
        }
    }

    protected Statement withAfters(FrameworkMethod method, Object testInstance, Statement statement) {
        Statement result = super.withAfters(method, testInstance, statement);
        for (TwipExtension extension : this.extensions) {
            result = extension.wrap(false, method, testInstance, result);
        }
        return result;
    }

    static {
        ClassLoader.getSystemClassLoader().setDefaultAssertionStatus(true);
    }
}

